/*
 * LlistarLocalsLlogater.java
 *
 * Created on 12 de junio de 2008, 18:04
 */

package actions;

import entitats.Client;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;
import locals.OpcionsLocal;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class LlistarLocalsLlogater extends Action {
    
    DataSource ds = null;
    Connection con = null;
    ResultSet rs = null;
    ArrayList <Local> locals = new ArrayList();
    String sql;
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        locals.OpcionsLocal opcions = (OpcionsLocal) form;
        locals.clear();
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            PreparedStatement sentencia = null;
            
            sql = "SELECT * FROM locals WHERE actiu = 1";
            
            if (opcions.getIdZona() >= 0)
                sql += " AND id_zona = "+opcions.getIdZona();
            if (opcions.getSuperficie() >= 0.0)
                sql += " AND superficie >= "+opcions.getSuperficie();
            if (opcions.getTipusLocal() != null)
                sql += " AND tipus = '"+opcions.getTipusLocal()+"'";
            
            rs = st.executeQuery(sql);
            
            if (rs.next()) {
                do{
                    Local local = new Local();
                    local.setAdresa(rs.getString("adresa"));
                    local.setCaracteristiques(rs.getString("caracteristiques"));
                    local.setCaracteristiquesPolivalents(rs.getString("caracteristiques_polivalent"));
                    local.setCodiLocal(rs.getString("codi_local"));
                    local.setIdLocal(rs.getInt("id"));
                    local.setIdPropietari(rs.getInt("id_propietari"));
                    local.setPreu(rs.getFloat("preu"));
                    local.setRestriccions(rs.getString("restriccions"));
                    local.setSuperficie(rs.getFloat("superficie"));
                    local.setTipus(rs.getString("tipus"));
                    local.setVolum(rs.getFloat("volum"));
                    local.setIdZona(rs.getInt("id_zona"));
                    locals.add(local);
                } while (rs.next());
            } else {
                opcions.setLlista("<b>La cerca no ha donat resultats</b>");
                return mapping.findForward("ok");
            }
            
            opcions.setLlistatLocals(locals);
            
        }catch(Exception excepcio){
            System.out.println("ERROR: "+excepcio.getMessage());
            opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarLocals:<br>" +
                    ""+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarLocals:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
